/** OTLN_Vers.c

	This file contains the standard version checking code for OTLN.
	
	Created 6/24/93 by dmc
	
	 1993 CoSA
	
**/
//#include <U.h>
#include "OTLNp.h"


#ifdef	USING_U
	/** OTLN_PkgVersion
	**/
	U_PkgVersion	OTLN_PkgObjectVersion(void)
	{
		return U_PKG_VERSION(OTLN_API_VERSION, OTLNp_CODE_VERSION);
	}


	/** OTLN_CheckVersions [1]
	**/
	Err				OTLN_CheckVersions(U_Location loc, U_PkgApiVersion api_vers)
	{
		register Err	err = Err_NONE;
		static Boolean	S_deep_check_done = FALSE;

		if (!S_deep_check_done) {
			S_deep_check_done = TRUE;

			err |= U_CHECK_VERSIONS(OTLNp_LOC(1), U);
			err |= U_CHECK_VERSIONS(OTLNp_LOC(1), STR);
			err |= U_CHECK_VERSIONS(OTLNp_LOC(1), M);
		}
		
		if (U_DIFF_API(loc, OTLN, api_vers)) 
			err = Err_OUT_OF_DATE;

		if (err) 
			err = Err_OUT_OF_DATE;			// in case we got a weird or-ing side-effect
			
		return err;
	}
#endif